/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CFileImpDrv98.h,v 1.3 2000/05/13 06:34:21 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CFileImpDrv98_h	// [
#define Included_CFileImpDrv98_h

#include "pgpClassesConfig.h"
#include "CFileImp.h"

_PGP_BEGIN

// Class CFileImpDrv98

class CFileImpDrv98 : public CFileImp
{
	friend class CPFLImpFactoryDrv98;

private:
	CFileImpDrv98() : mRing0Handle(NULL), mInt21Handle(0) { }
	~CFileImpDrv98();

	CComboError	GetLength(PGPUInt64& length) const;
	CComboError	GetUniqueFileId(PGPUInt64& fileId) const;

	CComboError	SetIsCompressed(PGPBoolean isCompressed);
	CComboError	SetLength(PGPUInt64 length);

	void		Flush();

	CComboError	Open(const char *path, PGPUInt32 flags);
	CComboError	Close();
	CComboError	Delete(const char *path);
	CComboError	Move(const char *oldPath, const char *newPath);

	CComboError	Read(void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const;
	CComboError	Write(const void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const;

private:
	PGPBoolean	mUseInt21;			// use int21 interface?

	HANDLE		mRing0Handle;		// Ring-0 file handle
	PGPUInt16	mInt21Handle;		// int21 file handle

	CComboError	GetLengthRing0(PGPUInt64& length) const;
	CComboError	GetLengthInt21(PGPUInt64& length) const;

	CComboError	OpenRing0(PGPUInt16 flags);
	CComboError	OpenInt21(PGPUInt16 flags);

	CComboError	CloseRing0();
	CComboError	CloseInt21();

	CComboError	SetFilePosInt21(PGPUInt32 pos) const;

	CComboError	ReadRing0(void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const;
	CComboError	ReadInt21Aux(void *buf, 
		PGPUInt32 nBytes) const;
	CComboError	ReadInt21(void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const;
	
	CComboError	WriteRing0(const void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const;
	CComboError	WriteInt21Aux(const void *buf, 
		PGPUInt32 nBytes) const;
	CComboError	WriteInt21(const void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const;
};

_PGP_END

#endif	// ] Included_CFileImpDrv98_h
